//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Diagnostics;

namespace WebProcessViewer
{
	/// <summary>
	/// Podsumowanie dla WebProcessForm.
	/// </summary>
	public class WebProcessForm : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Table ProcessTable;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Wygenerowanie wierszy i komrek           
			TableRow r = new TableRow();
			// Identyfikator procesu
			TableCell c = new TableCell();
			c.Controls.Add(new LiteralControl("Identyfikator procesu"));
			r.Cells.Add(c);
			// Nazwa procesu
			c = new TableCell();
			c.Controls.Add(new LiteralControl("Nazwa procesu"));
			r.Cells.Add(c);
			// Licznik wtkw
			c = new TableCell();
			c.Controls.Add(new LiteralControl("Licznik wtkw"));
			r.Cells.Add(c);
			// Zestaw roboczy
			c = new TableCell();
			c.Controls.Add(new LiteralControl("Zestaw roboczy"));
			r.Cells.Add(c);
			// Wielko pamici wirtualnej
			c = new TableCell();
			c.Controls.Add(new LiteralControl("Wielko pamici wirtualnej"));
			r.Cells.Add(c);
			// Cakowity czas procesora
			c = new TableCell();
			c.Controls.Add(new LiteralControl("Czas procesora"));
			r.Cells.Add(c);
			ProcessTable.Rows.Add(r);
			Process [] pa = Process.GetProcesses();
			foreach(Process p in pa)
			{
				ProcessThreadCollection ptc = p.Threads;
				r = new TableRow();
				// Identyfikator procesu
				c = new TableCell();
				c.HorizontalAlign = HorizontalAlign.Right;
				c.Controls.Add(new LiteralControl(p.Id.ToString()));
				r.Cells.Add(c);
				// Nazwa procesu
				c = new TableCell();
				c.HorizontalAlign = HorizontalAlign.Right;
				c.Controls.Add(new LiteralControl(p.ProcessName));
				r.Cells.Add(c);
				// Licznik wtkw
				c = new TableCell();
				c.HorizontalAlign = HorizontalAlign.Right;
				c.Controls.Add(new LiteralControl(ptc.Count.ToString("#,#")));
				r.Cells.Add(c);
				// Zestaw roboczy
				c = new TableCell();
				c.HorizontalAlign = HorizontalAlign.Right;
				c.Controls.Add(new LiteralControl(p.WorkingSet.ToString("#,#")));
				r.Cells.Add(c);
				// Wielko pamici wirtualnej
				c = new TableCell();
				c.HorizontalAlign = HorizontalAlign.Right;
				c.Controls.Add(new LiteralControl(p.VirtualMemorySize.ToString("#,#")));
				r.Cells.Add(c);
				// Cakowity czas procesora
				c = new TableCell();
				c.HorizontalAlign = HorizontalAlign.Right;
				c.Controls.Add(new LiteralControl(p.TotalProcessorTime.ToString()));
				r.Cells.Add(c);

				ProcessTable.Rows.Add(r);
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: To wywoanie jest wymagane przez ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
